<?php
/**
 * Start Module
 *
 * @package     AutomatorWP\Integrations\Thrive_Apprentice\Triggers\Start_Module
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Thrive_Apprentice_Start_Module extends AutomatorWP_Integration_Trigger {

    public $integration = 'thrive_apprentice';
    public $trigger = 'thrive_apprentice_start_module';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User starts a module in a course', 'automatorwp-pro' ),
            'select_option'     => __( 'User starts <strong>a module</strong> in a course', 'automatorwp-pro' ),
            /* translators: %1$s: Module title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User starts %1$s %2$s time(s)', 'automatorwp-pro' ), '{post}', '{times}' ),
            /* translators: %1$s: Module title. */
            'log_label'         => sprintf( __( 'User starts %1$s', 'automatorwp-pro' ), '{post}' ),
            'action'            => 'thrive_apprentice_module_start',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'post' => array(
                    'from' => 'module',
                    'default' => __( 'module', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_term_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                            'taxonomy' => 'tva_courses',
                        ) ),
                        'module' => automatorwp_utilities_ajax_selector_field( array(
                            'option_none' => false,
                            'option_custom' => false,
                            'placeholder'       => __( 'Select a module', 'automatorwp-pro' ),
                            'name' => __( 'Modules:', 'automatorwp-pro' ),
                            'action_cb' => 'automatorwp_thrive_apprentice_get_modules',
                            'options_cb' => 'automatorwp_thrive_apprentice_options_cb_modules',
                            'default' => ''
                        ) ),
                    )
                ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_thrive_apprentice_get_module_tags(),
                automatorwp_thrive_apprentice_get_course_tags(),
                automatorwp_utilities_post_tags( __( 'Module', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param  array  	$module_details
     * @param  array  	$user_details
     */
    public function listener( $module_details, $user_details ) {

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_details['user_id'],
            'module_id'   => $module_details['module_id'],
            'module_title'   => $module_details['module_title'],
            'course_id'   => $module_details['course_id'],
            'course_title'   => $module_details['course_title']
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */


    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['module_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( $trigger_options['module'] !== 'any' && absint( $trigger_options['module'] ) !== absint( $event['module_id'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

    /**
     * Register the required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_trigger_log_meta', array( $this, 'log_meta' ), 10, 6 );

        parent::hooks();
    }

    /**
     * Trigger custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return array
     */
    function log_meta( $log_meta, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Bail if action type don't match this action
        if( $trigger->type !== $this->trigger ) {
            return $log_meta;
        }

        $log_meta['module_id'] = ( isset( $event['module_id'] ) ? $event['module_id'] : '' );
        $log_meta['module_title'] = ( isset( $event['module_title'] ) ? $event['module_title'] : '' );
        $log_meta['course_id'] = ( isset( $event['course_id'] ) ? $event['course_id'] : '' );
        $log_meta['course_title'] = ( isset( $event['course_title'] ) ? $event['course_title'] : '' );
        
        return $log_meta;

    }

}

new AutomatorWP_Thrive_Apprentice_Start_Module();